  ' 091in OLED TB version.bas
  ' 
  ' A program to test drive a 0.91 inch OLED module from a Micromite.
  ' It was written by Tim Blythman using ideas and code taken from the program
  ' MatherP OLED.bas, written by Micromite programming guru Peter Mather, with
  ' a few ideas also taken from the program OLED module TEST prog5.bas, written
  ' by Jim Rowe. The latter program worked well with 1.3 inch OLED modules, but
  ' refused to work with the 0.91 in OLEDs.
  '  
  ' Note that data for 0.91in OLEDs only uses two groups of 4 bits: b0, b2, b4
  ' and b6 from page 0 and the corresponding bits from page 1. These are combined
  ' to produce a full 8-bit byte to send to the OLED module.
  ' &HAA appears solid white and &H55 still appears black
  '
  ' Last revised by Jim Rowe 14/5/2024 at 6:50 am
  ' -----------------------------------------------------------------------------
	OPTION AUTORUN ON
  OPTION LCDPANEL DISABLE
	OPTION EXPLICIT
	DIM STRING PStr$   ' string to store one page of SH1106/SSD1306
	DIM BM$(128) AS STRING LENGTH 16
	INITSTRINGS
	DIM INTEGER COL =0 ' need to store these so we can write over multiple pages
  DIM INTEGER OLpge =0  ' name changed from PAGE to avoid syntax problem with MM+

	I2C OPEN 400, 1000 ' enable the Micromite I2C port in master mode
	OLEDinit       ' go initialise the OLED
	OLEDclear(0)	''clear to black
	OLEDprintstring("  Hi! Silicon Chip 0.91in OLED")
  COL =0
  OLpge =2
  OLEDprintstring(" *                                    *")
  COL =0
  OLpge =4
  OLEDprintstring("*      Micromite here!        *")
  COL =0
  OLpge =6
  OLEDprintstring("****************************")
END
' ------------------------------------------------------------------------------
SUB OLEDcmd(d as INTEGER)	' a single command byte
	I2C WRITE &H3C,0,2,&H00,d
END SUB
' ------------------------------------------------------------------------------
SUB OLEDdata(d as INTEGER)	' a single data byte
	I2C WRITE &H3C,0,2,&H40,d
END SUB
' ------------------------------------------------------------------------------
SUB OLEDbitmap(d$ as STRING)	' send a string as bitmap data
	LOCAL STRING s$
	s$=CHR$(64)+d$
	I2C WRITE &H3C,0,len(s$),s$
END SUB
' -------------------------------------------------------------------------------
SUB OLEDinit
	OLEDcmd(&HAE)'DISPLAYOFF)
	OLEDcmd(&HD5)'DISPLAYCLOCKDIV
	OLEDcmd(&H80)'the suggested ratio &H80
	OLEDcmd(&HA8)'MULTIPLEX
	OLEDcmd(&H3F)'
	OLEDcmd(&HD3)'DISPLAYOFFSET
	OLEDcmd(&H0)'no offset
	OLEDcmd(&H40)'STARTLINE
	OLEDcmd(&H8D)'CHARGEPUMP
	OLEDcmd(&H14)
	OLEDcmd(&H20)'MEMORYMODE
	OLEDcmd(&H00)'&H0 act like ks0108
	OLEDcmd(&HA1)'SEGREMAP OR 1
	OLEDcmd(&HC8)'COMSCANDEC
	OLEDcmd(&HDA)'COMPINS
	OLEDcmd(&H12)
	OLEDcmd(&H81)'SETCONTRAST
	OLEDcmd(&HCF)
	OLEDcmd(&Hd9)'SETPRECHARGE
	OLEDcmd(&HF1)
	OLEDcmd(&HDB)'VCOMDETECT
	OLEDcmd(&H40)
	OLEDcmd(&HA4)'DISPLAYALLON_RESUME
	OLEDcmd(&HA6)'NORMALDISPLAY
	OLEDcmd(&HAF)'DISPLAYON
END SUB
' -------------------------------------------------------------------
SUB OLEDclear(n AS INTEGER)
	LOCAL INTEGER y
	PStr$=string$(128,chr$(n))
	FOR y = 0 TO 7
		OLEDsetx(0)
		OLEDsety(y)
		OLEDbitmap(PStr$)
	NEXT y
END SUB
' -------------------------------------------------------------------
SUB OLEDsetx(x as INTEGER)
	OLEDcmd(16+((x\16) AND 15))	'integer division, set high nybble of x
	OLEDcmd(x AND 15)	'set low nybble of x
END SUB
' -------------------------------------------------------------------
SUB OLEDsety(y as INTEGER)
	OLEDcmd(176+(y AND 7))	'set y
END SUB
' -------------------------------------------------------------------
SUB OLEDprintchar(i as integer)
	IF I<1 THEN EXIT SUB
	IF I>126 THEN EXIT SUB
	IF LEN(BM$(i))<1 THEN EXIT SUB
	OLEDsendstring(BM$(i))
END SUB
' --------------------------------------------------------------------
SUB OLEDprintstring(s$ AS STRING)
	LOCAL INTEGER I
	FOR I = 1 TO LEN(s$)
		OLEDprintchar(ASC(MID$(s$,I,1)))
	NEXT I
END SUB
' --------------------------------------------------------------------
SUB OLEDsendstring(s$ AS STRING)	'remaps a textchar string to suit this display,
  ' sends to current COL,OLpge and updates COL
	LOCAL STRING a$,b$	' for first, second scans
	LOCAL INTEGER i
	a$=""
	b$=""
	FOR I = 1 TO LEN(s$)
		a$=a$+CHR$(GETNYBBLE(ASC(MID$(s$,I,1))))
		b$=b$+CHR$(GETNYBBLE(ASC(MID$(s$,I,1))\16))
	NEXT I
	OLEDsetx(COL)
	OLEDsety(OLpge)
	OLEDbitmap(a$)
	OLEDsetx(COL)
	OLEDsety(OLpge +1)
	OLEDbitmap(b$)
	COL=COL+LEN(s$)
END SUB
' -------------------------------------------------------------------
FUNCTION GETNYBBLE(I AS INTEGER) AS INTEGER	'map bits in a nybble to every second bit in a byte
	GETNYBBLE=0
	IF (I AND 1) > 0 THEN GETNYBBLE=GETNYBBLE+3	' use 2-bit values to get a useful display on other types
	IF (I AND 2) > 0 THEN GETNYBBLE=GETNYBBLE+12
	IF (I AND 4) > 0 THEN GETNYBBLE=GETNYBBLE+48
	IF (I AND 8) > 0 THEN GETNYBBLE=GETNYBBLE+192
END FUNCTION
' -------------------------------------------------------------------

SUB INITSTRINGS
' -----------------------------------------------------------
  ' OLED MODULE textchar strings.bas
  ' A listing of the text character strings which are compatible
  ' with the Micromite program to drive a 1.3" OLED module based
  ' on the SH1106 or SSD1306 controller/driver chips.
  '
  ' Prepared by Jim Rowe for Silicon Chip
	' Updated by Tim Blythman to init the data to an array to ease handling
	' Also added .

  ' UPPER CASE LETTERS ---------------------------------------------

BM$(65)=  CHR$(&H7E)+CHR$(&H09)+CHR$(&H09)+CHR$(&H7E)+CHR$(&H00) 'A
BM$(66)=  CHR$(&H7F)+CHR$(&H49)+CHR$(&H49)+CHR$(&H36)+CHR$(&H00) 'B
BM$(67)=  CHR$(&H3E)+CHR$(&H41)+CHR$(&H41)+CHR$(&H22)+CHR$(&H00) 'C
BM$(68)=  CHR$(&H7F)+CHR$(&H41)+CHR$(&H41)+CHR$(&H3E)+CHR$(&H00) 'D
BM$(69)=  CHR$(&H7F)+CHR$(&H49)+CHR$(&H49)+CHR$(&H49)+CHR$(&H00) 'E
BM$(70)=  CHR$(&H7F)+CHR$(&H09)+CHR$(&H09)+CHR$(&H09)+CHR$(&H00) 'F
BM$(71)=  CHR$(&H4E)+CHR$(&H41)+CHR$(&H49)+CHR$(&H7A)+CHR$(&H00) 'G
BM$(72)=  CHR$(&H7F)+CHR$(&H08)+CHR$(&H08)+CHR$(&H7F)+CHR$(&H00) 'H
BM$(73)=  CHR$(&H41)+CHR$(&H7F)+CHR$(&H41)+CHR$(&H00) 'I
BM$(74)=  CHR$(&H30)+CHR$(&H40)+CHR$(&H40)+CHR$(&H3F)+CHR$(&H00) 'J
BM$(75)=  CHR$(&H7F)+CHR$(&H08)+CHR$(&H24)+CHR$(&H63)+CHR$(&H00) 'K
BM$(76)=  CHR$(&H7F)+CHR$(&H40)+CHR$(&H40)+CHR$(&H40)+CHR$(&H00) 'L
BM$(77)=  CHR$(&H7E)+CHR$(&H01)+CHR$(&H7E)+CHR$(&H01)+CHR$(&H7E)+CHR$(&H00) 'M
BM$(78)=  CHR$(&H7F)+CHR$(&H06)+CHR$(&H08)+CHR$(&H30)+CHR$(&H7F)+CHR$(&H00) 'N
BM$(79)=  CHR$(&H3E)+CHR$(&H41)+CHR$(&H41)+CHR$(&H3E)+CHR$(&H00) 'O
BM$(80)=  CHR$(&H7F)+CHR$(&H09)+CHR$(&H09)+CHR$(&H06)+CHR$(&H00) 'P
BM$(81)=  CHR$(&H3E)+CHR$(&H41)+CHR$(&H61)+CHR$(&HFE)+CHR$(&H00) 'Q
BM$(82)=  CHR$(&H7F)+CHR$(&H09)+CHR$(&H09)+CHR$(&H76)+CHR$(&H00) 'R
BM$(83)=  CHR$(&H26)+CHR$(&H49)+CHR$(&H49)+CHR$(&H32)+CHR$(&H00) 'S
BM$(84)=  CHR$(&H01)+CHR$(&H01)+CHR$(&H7F)+CHR$(&H01)+CHR$(&H01)+CHR$(&H00) 'T
BM$(85)=  CHR$(&H3F)+CHR$(&H40)+CHR$(&H40)+CHR$(&H3F)+CHR$(&H00) 'U
BM$(86)=  CHR$(&H1F)+CHR$(&H20)+CHR$(&H40)+CHR$(&H20)+CHR$(&H1F)+CHR$(&H00) 'V
BM$(87)=  CHR$(&H3F)+CHR$(&H40)+CHR$(&H3F)+CHR$(&H40)+CHR$(&H3F)+CHR$(&H00) 'W
BM$(88)=  CHR$(&H61)+CHR$(&H12)+CHR$(&H0C)+CHR$(&H12)+CHR$(&H61)+CHR$(&H00) 'X
BM$(89)=  CHR$(&H03)+CHR$(&H04)+CHR$(&H78)+CHR$(&H04)+CHR$(&H03)+CHR$(&H00) 'Y
BM$(90)=  CHR$(&H61)+CHR$(&H51)+CHR$(&H49)+CHR$(&H45)+CHR$(&H43)+CHR$(&H00) 'Z
BM$(32)=  CHR$(&H00)+CHR$(&H00)+CHR$(&H00)
' LOWER CASE LETTERS -----------------------------------------------
BM$(97)=  CHR$(&H38)+CHR$(&H44)+CHR$(&H48)+CHR$(&H7C)+CHR$(&H00) 'a
BM$(98)=  CHR$(&H7F)+CHR$(&H48)+CHR$(&H44)+CHR$(&H38)+CHR$(&H00) 'b
BM$(99)=  CHR$(&H38)+CHR$(&H44)+CHR$(&H44)+CHR$(&H08)+CHR$(&H00) 'c
BM$(100)=  CHR$(&H38)+CHR$(&H44)+CHR$(&H44)+CHR$(&H38)+CHR$(&H7F)+CHR$(&H00) 'd
BM$(101)=  CHR$(&H38)+CHR$(&H54)+CHR$(&H54)+CHR$(&H18)+CHR$(&H00) 'e
BM$(102)=  CHR$(&H08)+CHR$(&H7E)+CHR$(&H09)+CHR$(&H09)+CHR$(&H00) 'f
BM$(103)=  CHR$(&H18)+CHR$(&HA4)+CHR$(&HA4)+CHR$(&H7C)+CHR$(&H00) 'g
BM$(104)=  CHR$(&H7F)+CHR$(&H04)+CHR$(&H04)+CHR$(&H78)+CHR$(&H00) 'h
BM$(105)=  CHR$(&H44)+CHR$(&H7D)+CHR$(&H40)+CHR$(&H00) 'i
BM$(106)=  CHR$(&H80)+CHR$(&H80)+CHR$(&H7D)+CHR$(&H00) 'j
BM$(107)=  CHR$(&H7E)+CHR$(&H10)+CHR$(&H28)+CHR$(&H44)+CHR$(&H00) 'k
BM$(108)=  CHR$(&H7E)+CHR$(&H40)+CHR$(&H40)+CHR$(&H00) 'l
BM$(109)=  CHR$(&H78)+CHR$(&H04)+CHR$(&H78)+CHR$(&H04)+CHR$(&H78)+CHR$(&H00) 'm
BM$(110)=  CHR$(&H7C)+CHR$(&H08)+CHR$(&H04)+CHR$(&H78)+CHR$(&H00) 'n
BM$(111)=  CHR$(&H38)+CHR$(&H44)+CHR$(&H44)+CHR$(&H38)+CHR$(&H00) 'o
BM$(112)=  CHR$(&HFC)+CHR$(&H44)+CHR$(&H44)+CHR$(&H38)+CHR$(&H00) 'p
BM$(113)=  CHR$(&H38)+CHR$(&H44)+CHR$(&H64)+CHR$(&H78)+CHR$(&H00) 'q
BM$(114)=  CHR$(&H7C)+CHR$(&H08)+CHR$(&H04)+CHR$(&H08)+CHR$(&H00) 'r
BM$(115)=  CHR$(&H08)+CHR$(&H54)+CHR$(&H54)+CHR$(&H20)+CHR$(&H00) 's
BM$(116)=  CHR$(&H04)+CHR$(&H3E)+CHR$(&H44)+CHR$(&H40)+CHR$(&H00) 't
BM$(117)=  CHR$(&H7C)+CHR$(&H40)+CHR$(&H40)+CHR$(&H3C)+CHR$(&H00) 'u
BM$(118)=  CHR$(&H0C)+CHR$(&H30)+CHR$(&H40)+CHR$(&H30)+CHR$(&H0C)+CHR$(&H00) 'v
BM$(119)=  CHR$(&H3C)+CHR$(&H40)+CHR$(&H3C)+CHR$(&H40)+CHR$(&H3C)+CHR$(&H00) 'w
BM$(120)=  CHR$(&H44)+CHR$(&H28)+CHR$(&H10)+CHR$(&H28)+CHR$(&H44)+CHR$(&H00) 'x
BM$(121)=  CHR$(&H04)+CHR$(&H88)+CHR$(&H70)+CHR$(&H08)+CHR$(&H04)+CHR$(&H00) 'y
BM$(122)=  CHR$(&H64)+CHR$(&H54)+CHR$(&H4C)+CHR$(&H44)+CHR$(&H00) 'z
' NUMERALS ---------------------------------------------------------
BM$(48)=  CHR$(&H1C)+CHR$(&H22)+CHR$(&H41)+CHR$(&H22)+CHR$(&H1C)+CHR$(&H00) '0
BM$(49)=  CHR$(&H02)+CHR$(&H7F)+CHR$(&H00) '1
BM$(50)=  CHR$(&H62)+CHR$(&H51)+CHR$(&H49)+CHR$(&H46)+CHR$(&H00) '2
BM$(51)=  CHR$(&H22)+CHR$(&H41)+CHR$(&H49)+CHR$(&H36)+CHR$(&H00) '3
BM$(52)=  CHR$(&H18)+CHR$(&H14)+CHR$(&H12)+CHR$(&H7F)+CHR$(&H10)+CHR$(&H00) '4
BM$(53)=  CHR$(&H2F)+CHR$(&H49)+CHR$(&H49)+CHR$(&H31)+CHR$(&H00) '5
BM$(54)=  CHR$(&H3E)+CHR$(&H49)+CHR$(&H49)+CHR$(&H32)+CHR$(&H00) '6
BM$(55)=  CHR$(&H01)+CHR$(&H61)+CHR$(&H19)+CHR$(&H07)+CHR$(&H00) '7
BM$(56)=  CHR$(&H36)+CHR$(&H49)+CHR$(&H49)+CHR$(&H36)+CHR$(&H00) '8
BM$(57)=  CHR$(&H26)+CHR$(&H49)+CHR$(&H49)+CHR$(&H3E)+CHR$(&H00) '9
' SYMBOLS ----------------------------------------------------------
BM$(61)=  CHR$(&H14)+CHR$(&H14)+CHR$(&H14)+CHR$(&H14)+CHR$(&H14)+CHR$(&H00) '=
BM$(43)=  CHR$(&H08)+CHR$(&H08)+CHR$(&H7F)+CHR$(&H08)+CHR$(&H08)+CHR$(&H00) '+
BM$(45)=  CHR$(&H08)+CHR$(&H08)+CHR$(&H08)+CHR$(&H08)+CHR$(&H08)+CHR$(&H00) '-
BM$(33)=  CHR$(&H00)+CHR$(&H5F)+CHR$(&H00)+CHR$(&H00) '!
BM$(63)=  CHR$(&H02)+CHR$(&H51)+CHR$(&H09)+CHR$(&H06)+CHR$(&H00) '?
BM$(40)=  CHR$(&H3C)+CHR$(&HC3)+CHR$(&H00) '(
BM$(41)=  CHR$(&HC3)+CHR$(&H3C)+CHR$(&H00) ')
BM$(47)=  CHR$(&H80)+CHR$(&H60)+CHR$(&H18)+CHR$(&H06)+CHR$(&H01)+CHR$(&H00) '/
BM$(42)=  CHR$(&H08)+CHR$(&H2A)+CHR$(&H1C)+CHR$(&H7F)+CHR$(&H1C)+CHR$(&H2A)+CHR$(&H08)+CHR$(&H00) ' *
BM$(46)=  CHR$(&H40)+CHR$(&H00)+CHR$(&H00) '.
' 
END SUB
' ---------------------------------------------------------------------------